#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "gmstuff.h"
#include "map.h"
#include "switchstuff.h"
#include "wirestuff.h"

char *Mapfile;
char *Switchfile;
char *Tmpdir;
char *Wirelist;
char *Test_x1;
int Test_p1;
char *Test_x2;
int Test_p2;
int Hport = 0;
extern int My_host_id;

void
parse_args(
  int argc,
  char **argv)
{
  int c;
  extern char *optarg;

  Tmpdir = "/tmp/tmpdir";
  Wirelist = NULL;
  Test_x1 = NULL;

  while ((c = getopt(argc, argv, "i:m:s:W:D:")) != EOF) switch (c) {

  case 'D':
    Tmpdir = optarg;
    break;

  case 'm':	/* map file (input) */
    Mapfile = optarg;
    break;

  case 's':	/* switch file (input) */
    Switchfile = optarg;
    break;

  case 'W':	/* wiring list file (output) */
    Wirelist = optarg;
    break;

  case 'i':  /* Host port Id to test out of */
    Hport = atoi(optarg);
    break;

  }

  if (Mapfile == NULL) {
    fprintf(stderr, "Map file is required!\n");
    exit(1);
  }

  /* create Tmpdir */
  if (mkdir(Tmpdir, 0755) < 0 && errno != EEXIST) {
    perror(Tmpdir);
    exit(1);
  }
}

int
main(
  int argc,
  char **argv)
{
  struct mapfile mf;
  struct mapfile *mp;

  mp = &mf;
  parse_args(argc, argv);

  initialize_gm();

  mp->name = Mapfile;
  load_map_file(mp);
  find_self(mp);

	if (Hport >= mf.host[My_host_id].nport) {
  	fprintf(stderr, "Requested host port number too big\n");
    exit(1);
	}

  calc_xbar_routes(mp);	/* calculate routes to all xbars */

  load_switch_file();

  create_wiring_list(mp);
 
  output_wiring_list();

  close_gm();

  return 0;
}
